/**
* \file: UspiInputSource.cpp
*
* \version: 2.0
*
* \release: $Name:$
*
* Input source endpoint implementation using USPI touch
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/ESM / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <UspiInputSource.h>
#include "UspiInputSourceImpl.h"

namespace adit { namespace bdcl {

using std::unique_ptr;

UspiInputSource::UspiInputSource(IAditInputSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer)
: AditInputSource(inCallbacks, inCallbackDealer)
{
    impl = move(unique_ptr<UspiInputSourceImpl>(new UspiInputSourceImpl(inCallbacks, inCallbackDealer)));
}

UspiInputSource::~UspiInputSource()
{

}

void UspiInputSource::setConfigItem(std::string inKey, std::string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

bool UspiInputSource::initialize()
{
    return impl->initialize();
}

void UspiInputSource::teardown()
{
    impl->teardown();
}

} } /* namespace adit { namespace bdcl { */
